/*
 * Decompiled with CFR 0.152.
 */
package de.sventorben.keycloak.authentication.hidpd;

import java.util.Arrays;
import java.util.stream.Stream;
import org.keycloak.models.Constants;
import org.keycloak.models.IdentityProviderModel;

final class IdentityProviderModelConfig {
    private static final String DOMAINS_ATTRIBUTE_KEY = "home.idp.discovery.domains";
    private final IdentityProviderModel identityProviderModel;

    IdentityProviderModelConfig(IdentityProviderModel identityProviderModel) {
        this.identityProviderModel = identityProviderModel;
    }

    boolean hasDomain(String userAttributeName, String domain) {
        return this.getDomains(userAttributeName).anyMatch(domain::equalsIgnoreCase);
    }

    private Stream<String> getDomains(String userAttributeName) {
        String key = this.getDomainConfigKey(userAttributeName);
        String domainsAttribute = this.identityProviderModel.getConfig().getOrDefault(key, "");
        return Arrays.stream(Constants.CFG_DELIMITER_PATTERN.split(domainsAttribute));
    }

    private String getDomainConfigKey(String userAttributeName) {
        Object key = DOMAINS_ATTRIBUTE_KEY;
        if (userAttributeName != null) {
            String candidateKey = "home.idp.discovery.domains." + userAttributeName;
            if (this.identityProviderModel.getConfig().containsKey(candidateKey)) {
                key = candidateKey;
            }
        }
        return key;
    }
}

