/*
 * Decompiled with CFR 0.152.
 */
package de.sventorben.keycloak.authentication.hidpd;

import de.sventorben.keycloak.authentication.hidpd.HomeIdpDiscoverer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationSelectionOption;
import org.keycloak.authentication.FlowStatus;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.sessions.AuthenticationSessionModel;

public class HomeIdpDiscoveryRegistrationEmail
implements FormAction,
FormActionFactory {
    public static final String PROVIDER_ID = "registration-email-idp-action";
    public static final String ERROR_EMAIL_BOUND_TO_IDP = "emailBoundToIdp";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getHelpText() {
        return "Validates that email domain is not bound to an IDP.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void validate(ValidationContext context) {
        HomeIdpDiscoverer discoverer;
        List<IdentityProviderModel> idp;
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        ArrayList<FormMessage> errors = new ArrayList<FormMessage>();
        context.getEvent().detail("register_method", "form");
        if (formData.getFirst((Object)"email") != null && !(idp = (discoverer = new HomeIdpDiscoverer(new AuthenticationFlowContextAdapter(context))).discoverForUser((String)formData.getFirst((Object)"email"))).isEmpty()) {
            errors.add(new FormMessage("email", ERROR_EMAIL_BOUND_TO_IDP));
        }
        if (errors.size() > 0) {
            context.error("invalid_registration");
            context.validationError(formData, errors);
            return;
        }
        context.success();
    }

    public void success(FormContext context) {
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void close() {
    }

    public String getDisplayType() {
        return "Home IdP Discovery (Email Validation)";
    }

    public String getReferenceCategory() {
        return "Authorization";
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public FormAction create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public static class AuthenticationFlowContextAdapter
    implements AuthenticationFlowContext {
        private final ValidationContext context;

        public AuthenticationFlowContextAdapter(ValidationContext context) {
            this.context = context;
        }

        public UserModel getUser() {
            return null;
        }

        public void setUser(UserModel userModel) {
        }

        public List<AuthenticationSelectionOption> getAuthenticationSelections() {
            return null;
        }

        public void setAuthenticationSelections(List<AuthenticationSelectionOption> list) {
        }

        public void clearUser() {
        }

        public void attachUserSession(UserSessionModel userSessionModel) {
        }

        public AuthenticationSessionModel getAuthenticationSession() {
            return null;
        }

        public String getFlowPath() {
            return null;
        }

        public LoginFormsProvider form() {
            return null;
        }

        public URI getActionUrl(String s) {
            return null;
        }

        public URI getActionTokenUrl(String s) {
            return null;
        }

        public URI getRefreshExecutionUrl() {
            return null;
        }

        public URI getRefreshUrl(boolean b) {
            return null;
        }

        public void cancelLogin() {
        }

        public void resetFlow() {
        }

        public void resetFlow(Runnable runnable) {
        }

        public void fork() {
        }

        public void forkWithSuccessMessage(FormMessage formMessage) {
        }

        public void forkWithErrorMessage(FormMessage formMessage) {
        }

        public EventBuilder getEvent() {
            return null;
        }

        public EventBuilder newEvent() {
            return null;
        }

        public AuthenticationExecutionModel getExecution() {
            return null;
        }

        public RealmModel getRealm() {
            return this.context.getRealm();
        }

        public ClientConnection getConnection() {
            return null;
        }

        public UriInfo getUriInfo() {
            return null;
        }

        public KeycloakSession getSession() {
            return this.context.getSession();
        }

        public HttpRequest getHttpRequest() {
            return null;
        }

        public BruteForceProtector getProtector() {
            return null;
        }

        public AuthenticatorConfigModel getAuthenticatorConfig() {
            return null;
        }

        public FormMessage getForwardedErrorMessage() {
            return null;
        }

        public FormMessage getForwardedSuccessMessage() {
            return null;
        }

        public FormMessage getForwardedInfoMessage() {
            return null;
        }

        public void setForwardedInfoMessage(String s, Object ... objects) {
        }

        public String generateAccessCode() {
            return null;
        }

        public AuthenticationExecutionModel.Requirement getCategoryRequirementFromCurrentFlow(String s) {
            return null;
        }

        public void success() {
        }

        public void failure(AuthenticationFlowError authenticationFlowError) {
        }

        public void failure(AuthenticationFlowError authenticationFlowError, Response response) {
        }

        public void failure(AuthenticationFlowError authenticationFlowError, Response response, String s, String s1) {
        }

        public void challenge(Response response) {
        }

        public void forceChallenge(Response response) {
        }

        public void failureChallenge(AuthenticationFlowError authenticationFlowError, Response response) {
        }

        public void attempted() {
        }

        public FlowStatus getStatus() {
            return null;
        }

        public AuthenticationFlowError getError() {
            return null;
        }

        public String getEventDetails() {
            return null;
        }

        public String getUserErrorMessage() {
            return null;
        }
    }
}

