/*
 * Decompiled with CFR 0.152.
 */
package de.sventorben.keycloak.authentication.hidpd;

import de.sventorben.keycloak.authentication.hidpd.HomeIdpDiscoveryMatchingEmailAuthenticator;
import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ServerInfoAwareProviderFactory;

public final class HomeIdpDiscoveryMatchingEmailAuthenticatorFactory
implements AuthenticatorFactory,
ServerInfoAwareProviderFactory {
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
    private static final String PROVIDER_ID = "home-idp-discovery-matching-email";
    public static final String CONF_NEGATE = "negate";
    private Config.Scope config;

    public String getDisplayType() {
        return "Home IdP Discovery (Check Email Matches Provider)";
    }

    public String getReferenceCategory() {
        return "Authorization";
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Checks if the email attribute from the provider matches the configured SSO domains";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        ProviderConfigProperty negateOutput = new ProviderConfigProperty();
        negateOutput.setType("boolean");
        negateOutput.setName(CONF_NEGATE);
        negateOutput.setLabel("Negate output");
        negateOutput.setHelpText("Apply a NOT to the check result. When this is true, then the condition will evaluate to true if the email does NOT match the discovered idp.");
        return List.of(negateOutput);
    }

    public Authenticator create(KeycloakSession session) {
        return new HomeIdpDiscoveryMatchingEmailAuthenticator();
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public Map<String, String> getOperationalInfo() {
        String version = this.getClass().getPackage().getImplementationVersion();
        if (version == null) {
            version = "dev-snapshot";
        }
        return Map.of("Version", version);
    }
}

