/*
 * Decompiled with CFR 0.152.
 */
package de.sventorben.keycloak.authentication.hidpd;

import de.sventorben.keycloak.authentication.hidpd.HomeIdpDiscoverer;
import de.sventorben.keycloak.authentication.hidpd.HomeIdpDiscoveryMatchingEmailAuthenticatorFactory;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class HomeIdpDiscoveryMatchingEmailAuthenticator
implements ConditionalAuthenticator {
    private static final Logger LOG = Logger.getLogger(HomeIdpDiscoveryMatchingEmailAuthenticatorFactory.class);
    private static final String LINKING_IDENTITY_PROVIDER_NOTE = "LINKING_IDENTITY_PROVIDER";

    public boolean matchCondition(AuthenticationFlowContext context) {
        AuthenticationSessionModel clientSession = context.getAuthenticationSession();
        String linkingNote = clientSession.getAuthNote(LINKING_IDENTITY_PROVIDER_NOTE);
        if (linkingNote != null) {
            LOG.debug((Object)"Skipping email match check in client initiated account linking session");
            return true;
        }
        SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession((AuthenticationSessionModel)clientSession, (String)"BROKERED_CONTEXT");
        if (serializedCtx == null) {
            throw new AuthenticationFlowException("Not found serialized context in clientSession", AuthenticationFlowError.IDENTITY_PROVIDER_ERROR);
        }
        BrokeredIdentityContext brokerContext = serializedCtx.deserialize(context.getSession(), clientSession);
        String providerId = brokerContext.getIdpConfig().getProviderId();
        List<IdentityProviderModel> homeIdps = new HomeIdpDiscoverer(context).discoverForUser(serializedCtx.getEmail());
        boolean matchesEmail = homeIdps.stream().anyMatch(x -> x.isEnabled() && x.getProviderId().equals(providerId));
        LOG.debugf("Email %s %s identity provider %s", (Object)serializedCtx.getEmail(), (Object)(matchesEmail ? "matches" : "doesn't match"), (Object)providerId);
        AuthenticatorConfigModel authConfig = context.getAuthenticatorConfig();
        if (authConfig != null && authConfig.getConfig() != null) {
            boolean negateOutput = Boolean.parseBoolean((String)authConfig.getConfig().get("negate"));
            return negateOutput != matchesEmail;
        }
        return matchesEmail;
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

